#version 330

uniform mat4 UVN;
uniform mat4 PROJECTION;
uniform mat4 WORLD;
uniform mat4 NORMAL;


layout(location = 0) in vec3 position;
layout(location = 2) in vec3 normal;

out vec3 Position;
out vec3 Normal;

void main() { 
	gl_Position = PROJECTION * UVN * WORLD * vec4(position, 1.0f);
	Position = position;
	Normal = normalize((NORMAL*vec4(normal,1.0)).xyz);
	Normal = normal;
}